"use strict";

jQuery(document).ready(function($){
    var acceptedCookie = function() {
        var now = new Date();
        var expires = parseInt($('#easyCookie').data('expiresdays'));
        if(!$.isNumeric(expires)) {
            expires = 180;
        }
        $.cookie('ec-accepted', now.toString(), { expires: expires, path: '/' });
        $('#easyCookie').fadeOut(500);
    };
    
    if(!$.cookie('ec-accepted')) {
        $('#easyCookie').fadeIn(500);
        if($('#easyCookie').hasClass('ec-accept-on-scroll')) {
            $(window).on('scroll', function(){
                acceptedCookie();
                $(window).unbind('scroll');
            });
        }
    }
    $('#easyCookie .ec-accept').unbind('click');
    $('#easyCookie .ec-accept').on('click', function(e){
        e.preventDefault();
        acceptedCookie();
    });
});
