<?php

/**
 * EasyCookie
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * Plugin Name: EasyCookie
 * Plugin URI: https://www.21tools.it/projects/easycookie
 * Description: EasyCookie is a responsive cookie notification, in a easy and quick way you can setup a beautiful Cookie Notification for your website!
 * Version: 1.0
 * Author: 21 Tools
 * Author URI: https://www.21tools.it
 */

// If this file is called directly, abort.
if( !defined( 'WPINC' ) ) {
	exit();
}

define( 'EASYCOOKIE_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'EASYCOOKIE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

define( 'EASYCOOKIE_DEF_EXPIRESDAYS', 180 );

function easycookie_output_bar($content)
{
	$positionClass = strip_tags(get_option('easycookie_position')) == 'top' ? 'ec-top' : '';
	$iconClass = strip_tags(get_option('easycookie_icon')) ? 'ec-icon' : '';
	$themeClass = strip_tags(get_option('easycookie_theme')) == 'black' ? 'ec-black' : '';
	$acceptOnScrollClass = strip_tags(get_option('easycookie_accept_on_scroll')) ? 'ec-accept-on-scroll' : '';
	$doubleBtnClass = strip_tags(get_option('easycookie_btn_info_text')) ? 'ec-double-btn' : '';

    $return = '<section id="easyCookie" class="ec-fixed '.$positionClass.' '.$iconClass.' '.$themeClass.' '.$acceptOnScrollClass.' '.$doubleBtnClass.'" data-expiresdays="'.strip_tags(get_option('easycookie_expiresdays')).'">
		<div>
			<div class="ec-infos">
				'.strip_tags(get_option('easycookie_description')).'
			</div>
			<div class="ec-btns">
				<a href="#" class="ec-accept">'.strip_tags(get_option('easycookie_btn_accept_text')).'</a>
				'.($doubleBtnClass ? '<a href="'.strip_tags(get_option('easycookie_btn_info_link')).'" class="ec-empty">'.strip_tags(get_option('easycookie_btn_info_text')).'</a>' : '').'
			</div>
		</div>
	</section>';
    
    return $content.$return;
}

function easycookie_activate_set_default_options()
{
    add_option('easycookie_position', 'bottom');
    add_option('easycookie_icon', true);
    add_option('easycookie_theme', 'white');
    add_option('easycookie_accept_on_scroll', false);
    add_option('easycookie_expiresdays', EASYCOOKIE_DEF_EXPIRESDAYS);
    add_option('easycookie_description', 'We use cookies to ensure that we give you the best experience. If you continue using this website, we\'ll assume that you are happy about that.');
    add_option('easycookie_btn_accept_text', 'IT\'S OK');
    add_option('easycookie_btn_info_text', 'more info');
    add_option('easycookie_btn_info_link', '');
}

function easycookie_register_options_group()
{
    register_setting('easycookie_options_group', 'easycookie_position', array('type' => 'string'));
    register_setting('easycookie_options_group', 'easycookie_icon', array('type' => 'boolean'));
    register_setting('easycookie_options_group', 'easycookie_theme', array('type' => 'string'));
    register_setting('easycookie_options_group', 'easycookie_accept_on_scroll', array('type' => 'boolean'));
    register_setting('easycookie_options_group', 'easycookie_expiresdays', array('type' => 'integer'));
    register_setting('easycookie_options_group', 'easycookie_description', array('type' => 'string'));
    register_setting('easycookie_options_group', 'easycookie_btn_accept_text', array('type' => 'string'));
    register_setting('easycookie_options_group', 'easycookie_btn_info_text', array('type' => 'string'));
    register_setting('easycookie_options_group', 'easycookie_btn_info_link', array('type' => 'string'));
}

function easycookie_add_option_page()
{
    add_options_page('EasyCookie Options', 'EasyCookie Options', 'administrator', 'easycookie-options-page', 'easycookie_update_options_form');
}

function easycookie_update_options_form()
{
	?>
	<div class="wrap">
	    <h1>EasyCookie options</h1>
	    <form method="post" action="options.php">
			<?php settings_fields('easycookie_options_group'); ?>
			<table class="form-table">
       			<tbody>
       				<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_theme">Choose the notification bar Theme</label>
					    </th>
					    <td>
					        <select id="easycookie_theme" name="easycookie_theme" class="regular-text" required>
								<option value="white" <?php selected(strip_tags(get_option('easycookie_theme')), "white"); ?>>white</option>
								<option value="black" <?php selected(strip_tags(get_option('easycookie_theme')), "black"); ?>>black</option>
					        </select>
					        <span class="description"></span>
					    </td>
					</tr>
					<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_position">Choose the notification bar Position</label>
					    </th>
					    <td>
					        <select id="easycookie_position" name="easycookie_position" class="regular-text" required>
								<option value="top" <?php selected(strip_tags(get_option('easycookie_position')), "top"); ?>>top</option>
								<option value="bottom" <?php selected(strip_tags(get_option('easycookie_position')), "bottom"); ?>>bottom</option>
					        </select>
					        <span class="description"></span>
					    </td>
					</tr>
					<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_accept_on_scroll">Auto-accept when page scroll?</label>
					    </th>
					    <td>
					        <input type="checkbox" id="easycookie_accept_on_scroll" name="easycookie_accept_on_scroll" <?php if( strip_tags(get_option('easycookie_accept_on_scroll')) ){ echo 'checked'; } ?> />
					        <span class="description"></span>
					    </td>
					</tr>
					<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_icon">Icon visible?</label>
					    </th>
					    <td>
					        <input type="checkbox" id="easycookie_icon" name="easycookie_icon" <?php if( strip_tags(get_option('easycookie_icon')) ){ echo 'checked'; } ?> />
					        <span class="description"></span>
					    </td>
					</tr>
					<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_expiresdays">Days before cookie expiration</label>
					    </th>
					    <td>
					        <input type="number" id="easycookie_expiresdays" name="easycookie_expiresdays" class="regular-text" value="<?php echo strip_tags(get_option('easycookie_expiresdays')); ?>" required />
					        <span class="description"></span>
					    </td>
					</tr>
					<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_description">Message</label>
					    </th>
					    <td>
					        <textarea id="easycookie_description" name="easycookie_description" class="regular-text" style="height:200px;" required><?php echo strip_tags(get_option('easycookie_description')); ?></textarea>
					        <span class="description"></span>
					    </td>
					</tr>
					<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_btn_accept_text">Accept button text</label>
					    </th>
					    <td>
					        <input type="text" id="easycookie_btn_accept_text" name="easycookie_btn_accept_text" class="regular-text" value="<?php echo strip_tags(get_option('easycookie_btn_accept_text')); ?>" required />
					        <span class="description"></span>
					    </td>
					</tr>
					<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_btn_info_text">Info button text</label>
					    </th>
					    <td>
					        <input type="text" id="easycookie_btn_info_text" name="easycookie_btn_info_text" class="regular-text" value="<?php echo strip_tags(get_option('easycookie_btn_info_text')); ?>" />
					        <span class="description">Leave empty to hide the info button</span>
					    </td>
					</tr>
					<tr valign="top">
					    <th scope="row">
					        <label for="easycookie_btn_info_link">Info button url</label>
					    </th>
					    <td>
					        <input type="url" id="easycookie_btn_info_link" name="easycookie_btn_info_link" class="regular-text" value="<?php echo strip_tags(get_option('easycookie_btn_info_link')); ?>" />
					        <span class="description"></span>
					    </td>
					</tr>
	            </tbody>
	        </table>
	        <p class="submit">
               	<input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e('Save Changes') ?>" />
           	</p>
		</form>
	</div>
	<?php
}

register_activation_hook( __FILE__, 'easycookie_activate_set_default_options');

wp_enqueue_style('easycookie-style', EASYCOOKIE_PLUGIN_URL . 'css/style.css');

wp_enqueue_script('jquery-cookie-script', EASYCOOKIE_PLUGIN_URL . 'js/jquery.cookie.min.js', array('jquery'));

wp_enqueue_script('easycookie-script', EASYCOOKIE_PLUGIN_URL . 'js/script.js');

add_filter('the_content', 'easycookie_output_bar');

add_action ('admin_init', 'easycookie_register_options_group');

add_action('admin_menu', 'easycookie_add_option_page');
